/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.power;

import io.github.apace100.origins.component.OriginComponent;
import io.github.apace100.origins.power.HudRendered;
import io.github.apace100.origins.power.Power;
import io.github.apace100.origins.power.PowerType;
import io.github.apace100.origins.util.HudRender;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.LongNBT;

public class CooldownPower
extends Power
implements HudRendered {
    private long lastUseTime;
    public final int cooldownDuration;
    private final HudRender hudRender;

    public CooldownPower(PowerType<?> type, PlayerEntity player, int cooldownDuration, HudRender hudRender) {
        super(type, player);
        this.cooldownDuration = cooldownDuration;
        this.hudRender = hudRender;
    }

    public boolean canUse() {
        return this.player.func_130014_f_().func_82737_E() >= this.lastUseTime + (long)this.cooldownDuration && this.isActive();
    }

    public void use() {
        this.lastUseTime = this.player.func_130014_f_().func_82737_E();
        OriginComponent.sync(this.player);
    }

    public float getProgress() {
        float time = this.player.func_130014_f_().func_82737_E() - this.lastUseTime;
        return Math.min(1.0f, Math.max(time / (float)this.cooldownDuration, 0.0f));
    }

    public int getRemainingTicks() {
        return (int)Math.max(0L, (long)this.cooldownDuration - (this.player.func_130014_f_().func_82737_E() - this.lastUseTime));
    }

    public void modify(int changeInTicks) {
        this.lastUseTime += (long)changeInTicks;
        long currentTime = this.player.func_130014_f_().func_82737_E();
        if (this.lastUseTime > currentTime) {
            this.lastUseTime = currentTime;
        }
    }

    public void setCooldown(int cooldownInTicks) {
        long currentTime = this.player.func_130014_f_().func_82737_E();
        this.lastUseTime = currentTime - (long)Math.min(cooldownInTicks, this.cooldownDuration);
    }

    @Override
    public INBT toTag() {
        return LongNBT.func_229698_a_((long)this.lastUseTime);
    }

    @Override
    public void fromTag(INBT tag) {
        this.lastUseTime = ((LongNBT)tag).func_150291_c();
    }

    @Override
    public HudRender getRenderSettings() {
        return this.hudRender;
    }

    @Override
    public float getFill() {
        return this.getProgress();
    }

    @Override
    public boolean shouldRender() {
        return this.player.func_130014_f_().func_82737_E() - this.lastUseTime <= (long)this.cooldownDuration;
    }
}

